/*-----------------------------------------------------------------------*/
/* Copyright 2012 to current year.                                       */
/* AVEVA Solutions Limited and its subsidiaries. All rights reserved.    */
/*-----------------------------------------------------------------------*/
(function (angular) {
  var netViewWrapperCommands = (function () {
    return {
      loginOpenScanAndLookAt: function () {
        return 'OpenProjectWithURL';
      },

      openScan: function () {
        return 'ChangeBubble';
      },

      selectObject: function () {
        return 'HighlightEntity';
      },

      highlightOrCreateMarkup: function () {
        return 'HighlightOrCreateMarkup';
      },

      AVEVANET: function () {
        return 'AVEVANET';
      },

      openSSOProject: function () {
        return 'OpenSSOProject';
      }
    };
  })();

  var netViewListenerCommands = function (messageObj, listener) {
    var translationMap = {
      event: function () {
        listener.notifySubscribers(messageObj.data.event, messageObj.data.data);
      },
      'open-bubbleview': function () {
        listener.picked(messageObj.data.bubbleView);
      },
      'entity-selection': function () {
        listener.picked(messageObj.data.entity);
      }
    };

    if (!messageObj.data.type) return;

    return translationMap[messageObj.data.type]();
  };

  var aNetDashModule = angular.module('aveva.dashboard.custom');
  aNetDashModule.factory('NetViewWrapperCommands', function () {
    return netViewWrapperCommands;
  });
  aNetDashModule.factory('NetViewListenerCommands', function () {
    return netViewListenerCommands;
  });
  // eslint-disable-next-line no-undef
})(angular);
